/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp3;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.mrp3.CreatedSupplyHandler;
import cz.insophy.inplan.mrp3.Events;
import cz.insophy.inplan.mrp3.GenericDemand;
import cz.insophy.inplan.mrp3.GorSupply;
import cz.insophy.inplan.mrp3.SrSupply;
import cz.insophy.inplan.mrp3.Supply;
import cz.insophy.inplan.mrp3.SupplyVisitorAdapter;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Collections3;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCreatedSupplyHandler
extends SupplyVisitorAdapter<Events>
implements CreatedSupplyHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCreatedSupplyHandler.class);
    private Map<Material, Integer> gorNos;
    private Map<Material, Integer> srNos;
    private Superplan superplan;
    @Nullable
    private final PropertyDefinition latestPossibleStartPd;
    @Nullable
    private final PropertyDefinition latestPossibleEndPd;
    private final long productionBuffer;
    private final long timeToPrepareBuffer;

    public DefaultCreatedSupplyHandler(Superplan superplan, @Nullable String latestPossibleStartProperty, @Nullable String latestPossibleEndProperty, long productionBuffer, long timeToPrepareBuffer) {
        super(Events.EMPTY);
        PropertyDefinition pd;
        this.superplan = superplan;
        if (latestPossibleStartProperty != null) {
            pd = Preconditions.checkNotNull(superplan.getShopConf().getPropertyDefinition(GeneralizedActionRequest.class, latestPossibleStartProperty), "Property \"" + latestPossibleStartProperty + "\" is not present in the configuration (for GARs).");
            Preconditions.checkArgument(pd.getType() == PropertyDefinition.PropertyType.LONG, "Property \"" + latestPossibleStartProperty + "\" for GARs is not of type long.");
            this.latestPossibleStartPd = pd;
        } else {
            this.latestPossibleStartPd = null;
        }
        if (latestPossibleEndProperty != null) {
            pd = Preconditions.checkNotNull(superplan.getShopConf().getPropertyDefinition(GeneralizedActionRequest.class, latestPossibleEndProperty), "Property \"" + latestPossibleEndProperty + "\" is not present in the configuration (for GARs).");
            Preconditions.checkArgument(pd.getType() == PropertyDefinition.PropertyType.LONG, "Property \"" + latestPossibleEndProperty + "\" for GARs is not of type long.");
            this.latestPossibleEndPd = pd;
        } else {
            this.latestPossibleEndPd = null;
        }
        this.productionBuffer = productionBuffer;
        this.timeToPrepareBuffer = timeToPrepareBuffer;
        this.gorNos = Maps.newHashMap();
        this.srNos = Maps.newHashMap();
    }

    public DefaultCreatedSupplyHandler(Superplan superplan, @Nullable String latestPossibleStartProperty, @Nullable String latestPossibleEndProperty) {
        this(superplan, latestPossibleStartProperty, latestPossibleEndProperty, 0L, 0L);
    }

    @Override
    @Nonnull
    public Events handle(Supply supply) {
        return supply.accept(this);
    }

    @Override
    public Events visit(SrSupply supply) {
        Preconditions.checkState(!supply.isBound(), "A SrSupply to be handled is already bound!");
        Material m3 = supply.getMaterial();
        if (GeneralizedRequest.isDateValid(m3.getMaterialHorizon())) {
            SupplyRequest sr = new SupplyRequest(this.getSrId(m3), m3, Math.max(supply.getTime(), this.superplan.getFixationDate() + m3.getMaterialHorizon()), supply.getQty(), SupplyRequest.State.PROPOSED);
            supply.setSr(sr);
        } else {
            LOG.warn("A SR supply with infinite material horizon requested. No SR created.");
        }
        return Events.EMPTY;
    }

    @Override
    public Events visit(GorSupply supply) {
        Events events = new Events(Lists.newArrayList(), Lists.newArrayList());
        Product prod = (Product)supply.getMaterial();
        long time = supply.getTime();
        Actiongram ag = prod.getDefaultActiongram();
        double targetQty = supply.getQty() / Preconditions.checkNotNull(Collections3.search(ag.getRootAction().getProduces(), mq -> mq.getMaterial() == prod), "Root action does not produce desired product.").getQty();
        GeneralizedOrderRequest gor = new GeneralizedOrderRequest(this.getGorId(prod), prod, targetQty, this.superplan.getFixationDate(), time, GeneralizedOrderRequest.State.PROPOSED);
        gor.setActiongram(ag);
        this.dipGor(gor);
        supply.setGor(gor);
        boolean lastAction = true;
        for (GeneralizedActionRequest gar : Lists.reverse(gor.getGars())) {
            long prodLength = this.estimateProductionLength(gar) + this.productionBuffer;
            long minTimeToPrepare = gar.getAction().getMinTimeToPrepare() + this.timeToPrepareBuffer;
            for (MaterialQuantity mq2 : gar.getAction().getProduces()) {
                if (lastAction && mq2.getMaterial() == prod) continue;
                events.supplies.add(new GorSupply(gor, time, gor.getRequestedQty() * mq2.getQty(), mq2.getMaterial()));
            }
            if (this.latestPossibleEndPd != null) {
                gar.setProperty(this.latestPossibleEndPd, time);
            }
            time -= prodLength;
            if (this.latestPossibleStartPd != null) {
                gar.setProperty(this.latestPossibleStartPd, time);
            }
            time -= minTimeToPrepare;
            for (MaterialQuantity mq2 : gar.getAction().getBom().ingredients()) {
                events.demands.add(new GenericDemand(time, gor.getRequestedQty() * mq2.getQty(), mq2.getMaterial()));
            }
            lastAction = false;
        }
        return events;
    }

    private long estimateProductionLength(GeneralizedActionRequest gar) {
        return (long)Math.ceil((double)gar.getAction().getProductionTime() * gar.getRequestedQty());
    }

    private String getGorId(Product prod) {
        String id;
        do {
            id = prod.getId() + ":" + this.gorNos.computeIfAbsent(prod, m3 -> 0);
            this.gorNos.computeIfPresent(prod, (m3, i) -> i + 1);
        } while (this.superplan.getGor(id) != null);
        return id;
    }

    private String getSrId(Material mat) {
        String id;
        do {
            id = mat.getId() + ":" + this.srNos.computeIfAbsent(mat, m3 -> 0);
            this.srNos.computeIfPresent(mat, (m3, i) -> i + 1);
        } while (this.superplan.getSupplyRequest(id) != null);
        return id;
    }

    private void dipGor(GeneralizedOrderRequest gor) {
        this.superplan.addGor(gor);
        this.superplan.removeGor(gor);
    }
}

